//
//  MCStackTabbedPane.h
//  MCApplication
//
//  Created by Ali Lalani on 8/13/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import "MCStackPane.h"
#import "MCStackTabbedHeader.h"
#import "MCRolloverMenuButton.h"
#import "MCDisplayStateProtocol.h"

@class MCSquareTabView;

@interface MCStackTabbedPane : MCStackPane <MCDisplayState> {
	// Each element is a dictionary with keys: "View","DisplayName"
	NSMutableArray *_tabs; // the views we're subbing into the body
	
	float minimumTabWidth;
	float tabWidth;
	
	NSInteger selectedTabIndex;
	
	BOOL animatesSwitch;
	
	BOOL tabIsAnimating;
	NSImage *oldTabImage;
	NSImage *newTabImage;
	float tabAnimationProgress; // percent, between 0 and 1
	NSRect tabAnimationBodyFrame;
	NSRect tabAnimationButtonFrame;

	NSMutableDictionary *displayState;
	id                   displayStateDelegate;
}
- (IBAction)selectTab:(id)sender;
- (void)selectTabAtIndex:(NSInteger)anIndex expand:(BOOL)flag;
- (void)selectTabAtIndex:(int)anIndex;
- (void)selectTabWithIdentifier:(NSString *)ident;
- (void)configureTabAtIndex:(int)anIndex;
- (NSRect)calculatedTabFrame;
- (void)animateTabSwitchToButton:(MCRolloverMenuButton *)aButton newView:(NSView *)aView;

- (int)selectedTabIndex;

// Array of menu items for representation in the main menu (and anywhere else required)
- (NSArray *)menuItemsForTarget:(id)target action:(SEL)action;

/////////////// ACCESSORS ////////////////////////
- (void)setTabs:(NSMutableArray *)anArray;
- (NSMutableArray *)tabs;

- (float)minimumTabWidth;
- (void)setMinimumTabWidth:(float)aMinimumTabWidth;

- (float)tabWidth;
- (void)setTabWidth:(float)aTabWidth;

- (BOOL)animatesSwitch;
- (void)setAnimatesSwitch:(BOOL)flag;

#pragma mark DisplayStateReadWrite
- (void)writeSelectedTabToDisplayState;
- (void)readSelectedTabFromDisplayState;
@end
